<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-6 d-flex flex-column justify-content-center">
            <div class="install-card">

                <!-- Alert MSG -->
                <?php if(session()->has('error')): ?>
                    <div class="alert alert-danger alert-block">
                        <button type="button" class="close" data-dismiss="alert" title="Remove">X</button>
                        <strong><?php echo e(Session::get('error')); ?></strong>
                    </div>
                <?php elseif(session()->has('success')): ?>
                    <div class="alert alert-danger alert-block">
                        <button type="button" class="close" data-dismiss="alert" title="Remove">X</button>
                        <strong><?php echo e(Session::get('success')); ?></strong>
                    </div>
                <?php endif; ?>

                <h1 class="primary-color install-title"><?php echo e(__('label.installation_process_started')); ?></h1>
                <h1 class="install_sub_title"><?php echo e(__('label.we_are_checking_file_permissions_and_version')); ?></h1>
                <ul class="list-group mt-3 install-list">
                    <li class="list-group-item">
                        <?php
                            $phpVersion = number_format((float)phpversion(), 2, '.', '');
                        ?>
                        <?php if($phpVersion >= 8.1): ?>
                            <i class="fa-solid fa-circle-check fa-xl text-success mr-2"></i>
                        <?php else: ?>
                            <i class="fa-solid fa-circle-xmark fa-xl text-danger mr-2"></i>
                        <?php endif; ?>
                        <span><?php echo e(__('label.php_version_8.1')); ?></span>
                    </li>
                    <li class="list-group-item">
                        <?php if($permission['curl_enabled']): ?>
                            <i class="fa-solid fa-circle-check fa-xl text-success mr-2"></i>
                        <?php else: ?>
                            <i class="fa-solid fa-circle-xmark fa-xl text-danger mr-2"></i>
                        <?php endif; ?>
                        <?php echo e(__('label.curl_enabled')); ?>

                    </li>
                    <li class="list-group-item">
                        <?php if($permission['env_file']): ?>
                            <i class="fa-solid fa-circle-check fa-xl text-success mr-2"></i>
                        <?php else: ?>
                            <i class="fa-solid fa-circle-xmark fa-xl text-danger mr-2"></i>
                        <?php endif; ?>
                        <b><?php echo e(__('label.env')); ?></b> <?php echo e(__('label.file_permission')); ?>

                    </li>
                    <li class="list-group-item">
                        <?php if($permission['framework_file']): ?>
                            <i class="fa-solid fa-circle-check fa-xl text-success mr-2"></i>
                        <?php else: ?>
                            <i class="fa-solid fa-circle-xmark fa-xl text-danger mr-2"></i>
                        <?php endif; ?>
                        <b><?php echo e(__('label.storage/framework')); ?></b> <?php echo e(__('label.file_permission')); ?>

                    </li>
                    <li class="list-group-item">
                        <?php if($permission['logs_file']): ?>
                            <i class="fa-solid fa-circle-check fa-xl text-success mr-2"></i>
                        <?php else: ?>
                            <i class="fa-solid fa-circle-xmark fa-xl text-danger mr-2"></i>
                        <?php endif; ?>
                        <b><?php echo e(__('label.storage/log')); ?></b> <?php echo e(__('label.file_permission')); ?>

                    </li>
                </ul>
                <?php if($phpVersion >= 8.1 && $permission['curl_enabled'] == 1 && $permission['env_file'] == 1 && $permission['framework_file'] == 1 && $permission['logs_file'] == 1): ?>
                    <a href="<?php echo e(route('step2',['token'=>bcrypt('step_2')])); ?>" onclick="showLoder()" class="btn btn-install mt-3"><?php echo e(__('label.next')); ?><i class="fa-solid fa-angles-right ml-2"></i></a>
                <?php endif; ?>
                
                <!-- Footer -->
                <?php echo $__env->make('installation.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
        </div>
        <div class="col-lg-6 install-bg-img d-none d-lg-block">
            <img src="<?php echo e(asset('assets/imgs/install_bg.png')); ?>" alt="Software Installation">
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('installation.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/installation/step1.blade.php ENDPATH**/ ?>