<?php $__env->startSection('page_title', __('label.edit_tvshow')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm"><?php echo e(__('label.edit_tvshow')); ?></h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-10">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('label.dashboard')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(route('tvshow.index')); ?>"><?php echo e(__('label.tv_shows')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('label.edit_tvshow')); ?></li>
                    </ol>
                </div>
                <div class="col-sm-2 d-flex align-items-center justify-content-end">
                    <a href="<?php echo e(route('tvshow.index')); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('label.tv_shows')); ?></a>
                </div>
            </div>

            <form id="edit_TVShow" enctype="multipart/form-data">
                <input type="hidden" name="id" class="form-control" value="<?php echo e($result->id); ?>" id="id ">
                <input type="hidden" name="old_trailer_type" value="<?php echo e($result->trailer_type); ?>">
                <input type="hidden" name="old_trailer" value="<?php echo e($result->trailer_url); ?>">
                <input type="hidden" name="old_thumbnail" value="<?php if($result): ?><?php echo e($result->thumbnail); ?><?php endif; ?>">
                <input type="hidden" name="old_landscape" value="<?php if($result): ?><?php echo e($result->landscape); ?><?php endif; ?>">
                <div class="custom-border-card">
                    <?php $status = TMDB_Status(); ?>  <!-- 0- No, 1- Yes-->
                    <?php if($status == 0): ?>
                    <div class="form-row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label><?php echo e(__('label.name')); ?><span class="text-danger">*</span></label>
                                <input type="text" name="name" value="<?php echo e($result->name); ?>" class="form-control" placeholder="<?php echo e(__('label.enter_movies_name')); ?>" autofocus>
                            </div>
                        </div>
                    </div>
                    <?php elseif($status == 1): ?>
                    <div class="form-row">
                        <div class="col-md-2">
                            <div class="form-group pt-3">
                                <label><?php echo e(__('label.import_from_tmdb')); ?><span class="text-danger">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <input type="text" name="Tmdb_id" id="Tmdb_id" class="form-control" placeholder="<?php echo e(__('label.enter_tmdb_tv_show_id_eg')); ?>">
                                <label class="mt-1 text-gray"><?php echo e(__('label.tmdb_notes')); ?> <a href="https://www.reddit.com/r/jellyfin/comments/xf8uvg/where_to_find_tmdb_id/" target="_blank" class="btn-link"><?php echo e(__('label.click_here')); ?></a> </label>
                            </div>
                        </div>
                        <div class="col-md-2 ml-5">
                            <div class="form-group">
                                <button type="button" class="btn btn-default mw-120" onclick="tmdb_data_fetch()"><?php echo e(__('label.fetch')); ?></button>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-12 ml-5">
                            <div class="form-group">
                                <label><?php echo e(__('label.or')); ?></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-2 pt-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.tvshow_name')); ?><span class="text-danger">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-6 mb-3">
                            <div class="form-group">
                                <input type="text" name="name" value="<?php echo e($result->name); ?>" id="Tmdb_name" list="Tmdb_name_list" class="form-control" placeholder="<?php echo e(__('label.enter_tvshow_name')); ?>">
                                <datalist id="Tmdb_name_list"></datalist>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="custom-border-card">
                    <div class="form-row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?php echo e(__('label.type')); ?><span class="text-danger">*</span></label>
                                <select class="form-control" name="type_id">
                                    <option value=""><?php echo e(__('label.select_type')); ?></option>
                                    <?php $__currentLoopData = $type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value->id); ?>" <?php echo e($result->type_id == $value->id  ? 'selected' : ''); ?>>
                                        <?php echo e($value->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <?php $x = explode(",", $result->category_id); ?>
                                <label><?php echo e(__('label.category')); ?></label>
                                <select class="form-control" style="width:100%!important;" name="category_id[]" multiple id="category_id">
                                    <?php $__currentLoopData = $category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value->id); ?>" <?php echo e((in_array($value->id, $x)) ? 'selected' : ''); ?>>
                                        <?php echo e($value->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group">
                                <?php $y = explode(",", $result->language_id); ?>
                                <label><?php echo e(__('label.language')); ?></label>
                                <select class="form-control" style="width:100%!important;" name="language_id[]" id="language_id" multiple>
                                    <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value->id); ?>" <?php echo e((in_array($value->id, $y)) ? 'selected' : ''); ?>>
                                        <?php echo e($value->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?php echo e(__('label.release_date')); ?><span class="text-danger">*</span></label>
                                <input name="release_date" value="<?php echo e($result->release_date); ?>" type="date" class="form-control" id="release_date">
                            </div>
                        </div>
                        <div class="col-md-8">
                            <?php $z = explode(",", $result->cast_id); ?>
                            <div class="form-group">
                                <label><?php echo e(__('label.cast')); ?><span class="text-danger">*</span></label>
                                <select class="form-control" style="width:100%!important;" name="cast_id[]" multiple id="cast_id">
                                    <?php $__currentLoopData = $cast; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value->id); ?>" <?php echo e((in_array($value->id, $z)) ? 'selected' : ''); ?>>
                                        <?php echo e($value->name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label><?php echo e(__('label.is_title')); ?><span class="text-danger">*</span></label>
                                <div class="radio-group">
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="is_title" id="is_title_no" class="custom-control-input" value="0" <?php echo e($result->is_title == 0 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="is_title_no"><?php echo e(__('label.no')); ?></label>
                                    </div>
                                    <div class="custom-control custom-radio">
                                        <input type="radio" name="is_title" id="is_title_yes" class="custom-control-input" value="1" <?php echo e($result->is_title == 1 ? 'checked' : ''); ?>>
                                        <label class="custom-control-label" for="is_title_yes"><?php echo e(__('label.yes')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo e(__('label.producer')); ?><span class="text-danger">*</span></label>
                                <select class="form-control" name="producer_id">
                                    <option value=""><?php echo e(__('label.select_producer')); ?></option>
                                    <?php $__currentLoopData = $producer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value->id); ?>" <?php echo e($result->producer_id == $value->id  ? 'selected' : ''); ?>>
                                        <?php echo e($value->user_name); ?>

                                    </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="custom-border-card">
                    <div class="form-row">
                        <div class="form-group col-lg-4">
                            <label><?php echo e(__('label.trailer_type')); ?><span class="text-danger">*</span></label>
                            <select name="trailer_type" id="trailer_type" class="form-control">
                                <option value="server_video" <?php echo e($result->trailer_type == "server_video" ? 'selected' : ''); ?>><?php echo e(__('label.server_video')); ?></option>
                                <option value="external" <?php echo e($result->trailer_type == "external" ? 'selected' : ''); ?>><?php echo e(__('label.external_url')); ?></option>
                                <option value="youtube" <?php echo e($result->trailer_type == "youtube" ? 'selected' : ''); ?>><?php echo e(__('label.youtube')); ?></option>
                            </select>
                            <label class="mt-1 mb-2 text-gray"><?php echo e(__('label.video_notes')); ?><a href="https://commentpicker.com/youtube-video-id.php" target="_blank" class="btn-link"><?php echo e(__('label.click_here')); ?></a></label>
                        </div>
                        <div class="form-group col-lg-6 trailer_box">
                            <div style="display: block;">
                                <label><?php echo e(__('label.trailer')); ?><span class="text-danger">*</span></label>
                                <div id="filelist5"></div>
                                <div id="container5" style="position: relative;">
                                    <div class="form-group">
                                        <input type="file" id="uploadFile5" name="uploadFile5" style="position: relative; z-index: 1;" class="form-control">
                                    </div>
                                    <input type="hidden" name="trailer" id="mp3_file_name5" class="form-control">

                                    <div class="form-group">
                                        <a id="upload5" class="btn text-white" style="background-color:#4e45b8;"><?php echo e(__('label.upload_files')); ?></a>
                                    </div>
                                    <label class="text-gray"><?php if($result->trailer_type == 'server_video'): ?><?php echo e($result->trailer_url); ?><?php endif; ?></label>
                                </div>
                            </div>
                        </div>
                        <div class="form-group col-lg-6 trailer_url_box">
                            <label><?php echo e(__('label.trailer')); ?><span class="text-danger">*</span></label>
                            <input name="trailer_url" value="<?php if($result->trailer_type != 'server_video'): ?><?php echo e($result->trailer_url); ?><?php endif; ?>" type="url" class="form-control" placeholder="<?php echo e(__('label.enter_trailer_url')); ?>">
                        </div>
                    </div>
                </div>
                <div class="custom-border-card">
                    <div class="form-row">
                        <div class="col-6">
                            <div class="form-row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.description')); ?><span class="text-danger">*</span></label>
                                        <textarea name="description" class="form-control" rows="2" id="description" placeholder="Hello..."><?php echo e($result->description); ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row mt-3">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.is_rent')); ?><span class="text-danger">*</span></label>
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" name="is_rent" id="is_rent_no" class="custom-control-input" value="0" <?php echo e($result->is_rent == 0 ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="is_rent_no"><?php echo e(__('label.no')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" name="is_rent" id="is_rent_yes" class="custom-control-input" value="1" <?php echo e($result->is_rent == 1 ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="is_rent_yes"><?php echo e(__('label.yes')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.is_comment')); ?><span class="text-danger">*</span></label>
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" name="is_comment" id="is_comment_no" class="custom-control-input" value="0" <?php echo e($result->is_comment == 0 ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="is_comment_no"><?php echo e(__('label.no')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" name="is_comment" id="is_comment_yes" class="custom-control-input" value="1" <?php echo e($result->is_comment == 1 ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="is_comment_yes"><?php echo e(__('label.yes')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.is_like')); ?><span class="text-danger">*</span></label>
                                        <div class="radio-group">
                                            <div class="custom-control custom-radio">
                                                <input type="radio" name="is_like" id="is_like_no" class="custom-control-input" value="0" <?php echo e($result->is_like == 0 ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="is_like_no"><?php echo e(__('label.no')); ?></label>
                                            </div>
                                            <div class="custom-control custom-radio">
                                                <input type="radio" name="is_like" id="is_like_yes" class="custom-control-input" value="1" <?php echo e($result->is_like == 1 ? 'checked' : ''); ?>>
                                                <label class="custom-control-label" for="is_like_yes"><?php echo e(__('label.yes')); ?></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-row rent_price">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.price_list')); ?><span class="text-danger">*</span></label>
                                        <select class="form-control" name="price">
                                            <option value=""><?php echo e(__('label.select_price')); ?></option>
                                            <?php $__currentLoopData = $rent_price_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($value->id); ?>" <?php echo e($result->price == $value->id ? 'selected' : ''); ?>>
                                                <?php echo e($value->price); ?>

                                            </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label><?php echo e(__('label.rent_time_in_days')); ?><span class="text-danger">*</span></label>
                                        <input type="number" name="rent_day" value="<?php echo e($result->rent_day); ?>" class="form-control" placeholder="<?php echo e(__('label.enter_howmany_day')); ?>" min="0" value="0">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group ml-5">
                                <label class="ml-5"><?php echo e(__('label.thumbnail_image')); ?><span class="text-danger">*</span></label>
                                <div class="avatar-upload ml-5">
                                    <div class="avatar-edit">
                                        <input type='file' name="thumbnail" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUpload" title="<?php echo e(__('label.select_file')); ?>"></label>
                                    </div>
                                    <div class="avatar-preview">
                                        <img src="<?php echo e($result->thumbnail); ?>" alt="upload_img.png" id="imagePreview">
                                        <input type="hidden" class="form-control" id="thumbnail_tmdb" name="thumbnail_tmdb">
                                    </div>
                                </div>
                                <label class="mt-3 ml-5 text-gray"><?php echo e(__('label.maximum_size_2mb')); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group ml-5">
                                <label><?php echo e(__('label.landscape_image')); ?><span class="text-danger">*</span></label>
                                <div class="avatar-upload-landscape">
                                    <div class="avatar-edit-landscape">
                                        <input type='file' name="landscape" id="imageUploadLandscape" accept=".png, .jpg, .jpeg" />
                                        <label for="imageUploadLandscape" title="<?php echo e(__('label.select_file')); ?>"></label>
                                    </div>
                                    <div class="avatar-preview-landscape">
                                        <img src="<?php echo e($result->landscape); ?>" alt="upload_img.png" id="imagePreviewLandscape">
                                        <input type="hidden" class="form-control" id="landscape_tmdb" name="landscape_tmdb">
                                    </div>
                                </div>
                                <label class="mt-3 text-gray"><?php echo e(__('label.maximum_size_2mb')); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-right">
                    <button type="button" class="btn btn-default mw-120" onclick="edit_TVShow()"><?php echo e(__('label.update')); ?></button>
                    <a href="<?php echo e(route('tvshow.index')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('label.cancel')); ?></a>
					<input type="hidden" name="_method" value="PATCH">
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>
        function edit_TVShow() {

            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){
                var formData = new FormData($("#edit_TVShow")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("tvshow.update", [$result->id])); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'edit_TVShow', '<?php echo e(route("tvshow.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('<?php echo e(__("label.you_have_no_right_to_add_edit_and_delete")); ?>');
            }
        }

        $(document).ready(function() {
            $("#category_id").select2({placeholder: "<?php echo e(__('label.select_category')); ?>"});
            $("#language_id").select2({placeholder: "<?php echo e(__('label.select_language')); ?>"});
            $("#cast_id").select2({placeholder: "<?php echo e(__('label.select_cast')); ?>"});

            var trailer_type = "<?php echo $result->trailer_type; ?>";
            if (trailer_type == "server_video") {
                $(".trailer_url_box").hide();
            } else {
                $(".trailer_box").hide();
            }
            $('#trailer_type').change(function() {
                var optionValue = $(this).val();

                if (optionValue == 'server_video') {
                    $(".trailer_box").show();
                    $(".trailer_url_box").hide();
                } else {
                    $(".trailer_url_box").show();
                    $(".trailer_box").hide();
                }
            });

            var is_rent = "<?php echo $result->is_rent; ?>";
            if (is_rent == 1) {
                $(".rent_price").show();
            } else {
                $(".rent_price").hide();
            }
            $('input[type=radio][name=is_rent]').change(function() {
                if (this.value == 1) {
                    $(".rent_price").show();
                } else if (this.value == 0) {
                    $(".rent_price").hide();
                }
            });
        });

        $('#Tmdb_name').keyup(function() {
            var txtVal = this.value;

            if (txtVal.length >= 3) {
                var url = "<?php echo e(route('tvshow.serach.name', '')); ?>" + "/" + txtVal;
                $.ajax({
                    type: "POST",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: txtVal,
                    success: function(resp) {

                        if (resp.status == 200) {

                            if (resp.data.results.length > 0) {

                                var Title_Data = resp.data.results;

                                $('#Tmdb_name_list').empty();
                                for (let i = 0; i < Title_Data.length; i++) {
                                    $('#Tmdb_name_list').append('<option id="' + resp.data.results[i].id + '" value="' + resp.data.results[i].name + '"></option>');
                                }
                            }
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        toastr.error(errorThrown, textStatus);
                    }
                });
            }
        });
        $('#Tmdb_name').on('input', function() {
            var userText = $(this).val();

            $("#Tmdb_name_list").find("option").each(function() {
                if ($(this).val() == userText) {

                    var MoviesName = $("#Tmdb_name").val();
                    c_id = $('#Tmdb_name_list').find('option[value="' + MoviesName + '"]').attr('id');

                    $("#dvloader").show();
                    var url = "<?php echo e(route('tvshow.getdata', '')); ?>" + "/" + c_id;
                    $.ajax({
                        type: "POST",
                        url: url,
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: c_id,
                        success: function(resp) {
                            $("#dvloader").hide();

                            if (resp.status == 200) {
                                
                                var C_Id = resp.data.C_Id;
                                var L_Id = resp.data.L_Id;
                                var C_Insert_Data = resp.data.C_Insert_Data;
                                var L_Insert_Data = resp.data.L_Insert_Data;
                                var Cast_Id = resp.data.Cast_Id;
                                var Cast_Insert_Data = resp.data.Cast_Insert_Data;
                                var Thumbnail = resp.data.Thumbnail;
                                var Title = resp.data.Title;
                                var Description = resp.data.Description;
                                var Release_Date = resp.data.Release_Date;

                                // Append New Category
                                for (let i = 0; i < C_Insert_Data.length; i++) {
                                    var data = '<option value="' + C_Insert_Data[i].id + '">' + C_Insert_Data[i].name + '</option>';
                                    $('#category_id').append(data);
                                }
                                $("#category_id").val(C_Id).trigger("change");

                                // Append New Language
                                for (let i = 0; i < L_Insert_Data.length; i++) {
                                    var data = '<option value="' + L_Insert_Data[i].id + '">' + L_Insert_Data[i].name + '</option>';
                                    $('#language_id').append(data);
                                }
                                $("#language_id").val(L_Id).trigger("change");

                                // Append New Cast
                                for (let i = 0; i < Cast_Insert_Data.length; i++) {
                                    var data = '<option value="' + Cast_Insert_Data[i].id + '">' + Cast_Insert_Data[i].name + '</option>';
                                    $('#cast_id').append(data);
                                }
                                $("#cast_id").val(Cast_Id).trigger("change");

                                // Image 
                                $('#imagePreview').attr('src', Thumbnail);
                                $('#imagePreviewLandscape').attr('src', Thumbnail);
                                $('#thumbnail_tmdb').attr('value', Thumbnail);
                                $('#landscape_tmdb').attr('value', Thumbnail);
                                $('#description').val(Description);
                                $("#release_date").attr('value', Release_Date);
                            }
                        },
                        error: function(XMLHttpRequest, textStatus, errorThrown) {
                            $("#dvloader").hide();
                            toastr.error(errorThrown, textStatus);
                        }
                    });
                }
            })
        })
        function tmdb_data_fetch() {

            var id = $("#Tmdb_id").val();

            if (id != "") {

                $("#dvloader").show();
                var url = "<?php echo e(route('tvshow.getdata', '')); ?>" + "/" + id;
                $.ajax({
                    type: "POST",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: id,
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            
                            var C_Id = resp.data.C_Id;
                            var L_Id = resp.data.L_Id;
                            var C_Insert_Data = resp.data.C_Insert_Data;
                            var L_Insert_Data = resp.data.L_Insert_Data;
                            var Cast_Id = resp.data.Cast_Id;
                            var Cast_Insert_Data = resp.data.Cast_Insert_Data;
                            var Thumbnail = resp.data.Thumbnail;
                            var Title = resp.data.Title;
                            var Description = resp.data.Description;
                            var Release_Date = resp.data.Release_Date;

                            // Append New Category
                            for (let i = 0; i < C_Insert_Data.length; i++) {
                                var data = '<option value="' + C_Insert_Data[i].id + '">' + C_Insert_Data[i].name + '</option>';
                                $('#category_id').append(data);
                            }
                            $("#category_id").val(C_Id).trigger("change");

                            // Append New Language
                            for (let i = 0; i < L_Insert_Data.length; i++) {
                                var data = '<option value="' + L_Insert_Data[i].id + '">' + L_Insert_Data[i].name + '</option>';
                                $('#language_id').append(data);
                            }
                            $("#language_id").val(L_Id).trigger("change");

                            // Append New Cast
                            for (let i = 0; i < Cast_Insert_Data.length; i++) {
                                var data = '<option value="' + Cast_Insert_Data[i].id + '">' + Cast_Insert_Data[i].name + '</option>';
                                $('#cast_id').append(data);
                            }
                            $("#cast_id").val(Cast_Id).trigger("change");

                            // Image 
                            $('#imagePreview').attr('src', Thumbnail);
                            $('#imagePreviewLandscape').attr('src', Thumbnail);
                            $('#thumbnail_tmdb').attr('value', Thumbnail);
                            $('#landscape_tmdb').attr('value', Thumbnail);
                            $('#description').val(Description);
                            $("#release_date").attr('value', Release_Date);

                            // Title
                            $('#Tmdb_name').val(Title);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                alert('<?php echo e(__("label.please_enter_tmdb_id")); ?>');
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtlive/resources/views/admin/tv_show/edit.blade.php ENDPATH**/ ?>